/*
 * Decompiled with CFR 0.152.
 */
package pse.pt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import skeletonapplet.PacketTracerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacketTracerLauncher {
    protected PacketTracerLocator locator;

    public PacketTracerLauncher() {
        this(new PacketTracerLocator());
    }

    public PacketTracerLauncher(PacketTracerLocator packetTracerLocator) {
        this.locator = packetTracerLocator;
    }

    public Process launch() {
        return this.launch(0, false);
    }

    public Process launch(int n, boolean bl) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(this.getCommandTokens(n, bl, null));
            File file = this.locator.getBinDirectory();
            Map<String, String> map = processBuilder.environment();
            String string = this.locator.getPathVariable();
            String string2 = this.locator.getPathSeparator();
            String string3 = map.get(string);
            if (string3 == null || string3.trim().length() == 0) {
                map.put(string, file.getCanonicalPath());
            } else {
                string3 = file.getCanonicalPath() + string2 + string3;
                map.put(string, string3);
            }
            processBuilder = processBuilder.directory(this.locator.getHomeDirectory());
            processBuilder = processBuilder.redirectErrorStream(true);
            return processBuilder.start();
        }
        catch (Exception exception) {
            throw new Error("Unable to launch Packet Tracer", exception);
        }
    }

    protected List<String> getCommandTokens(int n, boolean bl, File file) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.wrapToken(this.locator.getExecutableString()));
        if (bl) {
            arrayList.add(this.wrapToken("--no-gui"));
        }
        if (n != 0) {
            arrayList.add(this.wrapToken("--ipc-port"));
            arrayList.add(this.wrapToken(String.valueOf(n)));
        }
        if (file != null) {
            arrayList.add(this.wrapToken(file.getCanonicalPath()));
        }
        return arrayList;
    }

    protected String wrapToken(String string) {
        return string.indexOf(" ") >= 0 ? "\"" + string + "\"" : string;
    }
}

